/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.progression;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidator;
import dev.toma.gunsrpg.common.skills.core.TransactionValidatorRegistry;
import dev.toma.gunsrpg.resource.SingleJsonFileReloadListener;
import dev.toma.gunsrpg.resource.progression.IProgressionStrategy;
import dev.toma.gunsrpg.resource.progression.ProgressionStrategy;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class ProgressionStrategyManager
extends SingleJsonFileReloadListener {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Levels");
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(IProgressionStrategy.class, (Object)new ProgressionStrategy.Adapter()).create();
    private final Map<ITransactionValidator, IProgressionStrategy> definedStrategies = new IdentityHashMap<ITransactionValidator, IProgressionStrategy>();

    public ProgressionStrategyManager() {
        super(GunsRPG.makeResource("leveling_strategy.json"), GSON);
    }

    public IProgressionStrategy getStrategy(ITransactionValidator validator) {
        return this.definedStrategies.get(validator);
    }

    protected void apply(JsonElement json, IResourceManager resourceManager, IProfiler profiler) {
        try {
            GunsRPG.log.info(MARKER, "Loading leveling strategies");
            this.definedStrategies.clear();
            this.load(json);
            GunsRPG.log.info(MARKER, "Leveling strategies have been loaded");
        }
        catch (JsonParseException exception) {
            GunsRPG.log.error(MARKER, "Exception occurred while loading leveling strategies, aborting... {}", (Object)exception.toString());
        }
    }

    private void load(JsonElement element) {
        JsonObject object = JsonHelper.asJsonObject(element);
        Set<String> keyDefinitions = this.loadKeys(JSONUtils.func_151214_t((JsonObject)object, (String)"types"));
        Map<String, Target> targetDefinitions = this.loadTargets(JSONUtils.func_151214_t((JsonObject)object, (String)"targets"));
        this.ensureAllTargetsDefined(keyDefinitions, targetDefinitions);
        JsonObject definitions = JSONUtils.func_152754_s((JsonObject)object, (String)"definitions");
        for (String key : keyDefinitions) {
            JsonObject strategyJson = JSONUtils.func_152754_s((JsonObject)definitions, (String)key);
            IProgressionStrategy strategy = (IProgressionStrategy)GSON.fromJson((JsonElement)strategyJson, IProgressionStrategy.class);
            Target target = targetDefinitions.get(key);
            Object factory = TransactionValidatorRegistry.getValidatorFactory(target.type);
            for (ResourceLocation location : target.identifiers) {
                JsonElement data = JsonHelper.toSimpleJson(location);
                Object validator = TransactionValidatorRegistry.getTransactionValidator(factory, data);
                if (validator == null) {
                    throw new JsonSyntaxException("Invalid identifier for type " + target.type + ", no match found for " + location + " identifier.");
                }
                this.definedStrategies.put((ITransactionValidator)validator, strategy);
            }
        }
    }

    private void ensureAllTargetsDefined(Set<String> keys, Map<String, Target> targets) {
        for (String key : keys) {
            Target target = targets.get(key);
            if (target != null) continue;
            throw new JsonSyntaxException("Missing target definition for " + key);
        }
    }

    private Map<String, Target> loadTargets(JsonArray array) {
        HashMap<String, Target> targets = new HashMap<String, Target>();
        for (JsonElement element : array) {
            JsonObject object = JsonHelper.asJsonObject(element);
            Target target = Target.resolveJson(object);
            targets.put(target.targetId, target);
        }
        return targets;
    }

    private Set<String> loadKeys(JsonArray array) {
        HashSet<String> strings = new HashSet<String>(array.size());
        for (JsonElement element : array) {
            strings.add(element.getAsString());
        }
        return strings;
    }

    static class Target {
        private String targetId;
        private ResourceLocation type;
        private ResourceLocation[] identifiers;

        Target() {
        }

        public static Target resolveJson(JsonObject object) {
            Target target = new Target();
            target.targetId = JSONUtils.func_151200_h((JsonObject)object, (String)"strategy");
            target.type = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"key"));
            target.identifiers = Target.resolveIdentifiers(JSONUtils.func_151214_t((JsonObject)object, (String)"identification"));
            return target;
        }

        private static ResourceLocation[] resolveIdentifiers(JsonArray array) {
            ResourceLocation[] locations = new ResourceLocation[array.size()];
            int index = 0;
            for (JsonElement element : array) {
                locations[index++] = element.isJsonNull() ? null : new ResourceLocation(element.getAsString());
            }
            return locations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Target target = (Target)o;
            return this.targetId.equals(target.targetId);
        }

        public int hashCode() {
            return this.targetId.hashCode();
        }
    }
}

